C23456789012345678901234567890123456789012345678901234567890123456789012
        PROGRAM ADDCOVS
	
C To combine covariance matrices for two estimated rotations in 
C order to derive a covariance matrix for the estimated rotation
C that is the sum of the two estimated rotations, in the case
C where the rotations are parameterised using lat-lon-angle
C According to Chang et al. 1990 (GJI, 101, 649-661)

C needs library newinvlib.a

	    IMPLICIT NONE
	    
	    INTEGER i
	
	    DOUBLE PRECISION LONA, LATA, ANGA, LONB, LATB, ANGB 
	    DOUBLE PRECISION LONC, LATC, ANGC
	    DOUBLE PRECISION RADDEG
	    DOUBLE PRECISION A(3,3), B(3,3), C(3,3)
        DOUBLE PRECISION D(3,3), G(3,3), F(3,3)
        DOUBLE PRECISION DTRANS(3,3), GTRANS(3,3), FTRANS(3,3)
        DOUBLE PRECISION DINV(3,3), DTRANSINV(3,3)
        DOUBLE PRECISION GDOTA(3,3), FDOTB(3,3)
        DOUBLE PRECISION CHANG1(3,3), CHANG2(3,3)
        DOUBLE PRECISION DCDTRANS(3,3), CDTRANS(3,3)

        CHARACTER(40) OPENFILEA, OPENFILEB, OPENFILEC
        
        LOGICAL OK_FLAG
        
        CALL GETARG (1, OPENFILEA)
		CALL GETARG (2, OPENFILEB)
		CALL GETARG (3, OPENFILEC)

c Get rotations for A B & C, & the variances and covariances for A & B
c First off assembled in a file and formatted by a front-end script.

        RADDEG=0.1745329251994329D-01

        OPEN( 10, FILE = OPENFILEA, STATUS = 'OLD' )
        
c NB FORTRAN stores matrices in arrays in column major order

        READ (10, * ) LONA, LATA, ANGA, A(1,1), A(1,2), 
     .    A(1,3), A(2,1), A(2,2), A(2,3), A(3,1), A(3,2), A(3,3)
        LONA=LONA*RADDEG 
        LATA=LATA*RADDEG
        ANGA=ANGA*RADDEG
        CLOSE(10)
        
        OPEN( 11, FILE = OPENFILEB, STATUS = 'OLD' )
        READ (11, *) LONB, LATB, ANGB, B(1,1), B(1,2), B(1,3), 
     .    B(2,1), B(2,2), B(2,3), B(3,1), B(3,2), B(3,3)
c        write(6,*)LONB,LATB,ANGB
c	     write(6,*)"A:",A
c	     write(6,*)"B:",B
        LONB=LONB*RADDEG 
        LATB=LATB*RADDEG
        ANGB=ANGB*RADDEG
        CLOSE(11)
        
        OPEN( 12, FILE = OPENFILEC, STATUS = 'OLD' )
        READ (12,*) LONC, LATC, ANGC
        LONC=LONC*RADDEG 
        LATC=LATC*RADDEG
        ANGC=ANGC*RADDEG
        CLOSE(12)
c        write(6,*)LONA,LATB,ANGB,LONB,LATB,ANGB,LONC,LATC,ANGC

        
c populate the matrices D,G,F
        D(1,1)=(-1.0)*DSIN(ANGC/2)*DCOS(LONC)*DSIN(LATC)
        D(1,2)=(-1.0)*DSIN(ANGC/2)*DSIN(LONC)*DCOS(LATC)
        D(1,3)=0.5*DCOS(ANGC/2)*DCOS(LONC)*DCOS(LATC)
        D(2,2)=DSIN(ANGC/2)*DCOS(LONC)
        D(2,3)=0.5*DCOS(ANGC/2)*DSIN(LONC)
        D(3,3)=-0.5*DSIN(ANGC/2)
        D(2,1)=0D0
        D(3,1)=0D0
        D(3,2)=0D0
    

        G(1,1)=((-1.0)*(DSIN(ANGA/2)*DCOS(ANGB/2))*DCOS(LONA)
     .           *DSIN(LATA))+ 
     .       DSIN(ANGA/2)*DSIN(ANGB/2)*DCOS(LONA)*DSIN(LONB)
     .       *DCOS(LATA)
     
        F(1,1)=((DCOS(ANGA/2)*DSIN(ANGB/2)*DCOS(LONB)
     .           *DSIN(LATB)))- 
     .       (DSIN(ANGA/2)*DSIN(ANGB/2)*DSIN(LONA)*DCOS(LONB)
     .       *DCOS(LATB))
     
        G(2,1)=((-1.0)*(DSIN(ANGA/2)*DCOS(ANGB/2)*DSIN(LONA)*
     .       DCOS(LATA))) + 
     .       (DSIN(ANGA/2)*DSIN(ANGB/2)*((-1.0)*DSIN(LONA)
     .       *DSIN(LONB)*DSIN(LATA) 
     .       - DCOS(LONA)*DCOS(LONB)*DSIN(LATB)))
     
        F(2,1)=((-1.0)*(DCOS(ANGA/2)*DSIN(ANGB/2)*DSIN(LONB)
     .          *DCOS(LATB)))+ 
     .       (DSIN(ANGA/2)*DSIN(ANGB/2)*(DCOS(LONA)*DCOS(LONB)
     .       *DSIN(LATA)+DSIN(LONA)*DSIN(LONB)*DSIN(LATB)))
     
        G(3,1)=0.5*((DCOS(ANGA/2)*DCOS(ANGB/2)*DCOS(LONA)*DCOS(LATA))- 
     .       (DSIN(ANGA/2)*DSIN(ANGB/2)*DCOS(LONB)*DCOS(LATB)) + 
     .       ((DCOS(ANGA/2)*DSIN(ANGB/2))*((DCOS(LONA)*DSIN(LONB)
     .       *DSIN(LATA)) - (DSIN(LONA)*DCOS(LONB)*DSIN(LATB)))))
     
        F(3,1)=0.5*(((-1.0)*(DSIN(ANGA/2)*DSIN(ANGB/2)*DCOS(LONA)
     .       *DCOS(LATA)))+
     .       (DCOS(ANGA/2)*DCOS(ANGB/2)*DCOS(LONB)*DCOS(LATB)) + 
     .       (DSIN(ANGA/2)*DCOS(ANGB/2))*((DCOS(LONA)*DSIN(LONB)*
     .       DSIN(LATA)) - (DSIN(LONA)*DCOS(LONB)*DSIN(LATB))))
     
        G(1,2)=(-1.0)*(DSIN(ANGA/2)*DSIN(ANGB/2)*DCOS(LONA)*
     .       DCOS(LONB)*DCOS(LATB-LATA))
     
        F(1,2)=G(1,2)*(-1.0)
        
        G(2,2)=(DSIN(ANGA/2)*DCOS(ANGB/2)*DCOS(LONA)) - 
     .       (DSIN(ANGA/2)*DSIN(ANGB/2)*DSIN(LONA)*DCOS(LONB)
     .       *DSIN(LATB-LATA))
     
        F(2,2)=(DCOS(ANGA/2)*DSIN(ANGB/2)*DCOS(LONB)) - 
     .       (DSIN(ANGA/2)*DSIN(ANGB/2)*DCOS(LONA)*DSIN(LONB)
     .       *DSIN(LATB-LATA))
     
        G(3,2)=0.5*((DCOS(ANGA/2)*DCOS(ANGB/2)*DSIN(LONA)) - 
     .       (DSIN(ANGA/2)*DSIN(ANGB/2)*DSIN(LONB)) + 
     .       (DCOS(ANGA/2)*DSIN(ANGB/2)*DCOS(LONA)*DCOS(LONB)
     .       *DSIN(LATB-LATA)))
     
        F(3,2)=0.5*(((-1.0)*(-DSIN(ANGA/2)*DSIN(ANGB/2)*DSIN(LONA))) + 
     .       (DCOS(ANGA/2)*DCOS(ANGB/2)*DSIN(LONB)) + 
     .       (DSIN(ANGA/2)*DCOS(ANGB/2)*DCOS(LONA)*DCOS(LONB)
     .       *DSIN(LATB-LATA)))
     
        G(1,3)=(-1.0)*(DSIN(ANGA/2)*DSIN(ANGB/2)*DCOS(LONA)*
     .       DCOS(LONB)*DSIN(LATB-LATA))
     
        F(1,3)=G(1,3)*(-1.0)
        
        G(2,3)=((-1.0)*DSIN(ANGA/2))*DSIN(ANGB/2)*
     .         ((-1.0)*DSIN(LONA)*DCOS(LONB)*DCOS(LATB-LATA) +
     .         (DCOS(LONA)*DSIN(LONB)))
     
        F(2,3)=((-1.0)*(DSIN(ANGA/2)*DSIN(ANGB/2))*((-(1.0)*DCOS(LONA)*
     .       DSIN(LONB)*DCOS(LATB-LATA)) + (DSIN(LONA)*DCOS(LONB))))
        
        G(3,3)=0.5*((DSIN(ANGA/2)*DCOS(ANGB/2)) - 
     .          (DCOS(ANGA/2)*DSIN(ANGB/2)*((DCOS(LONA)*DCOS(LONB)*
     .           DCOS(LATB-LATA)) + (DSIN(LONA)*DSIN(LONB)))))
        
        F(3,3)=0.5*(((-1.0)*DCOS(ANGA/2)*DSIN(ANGB/2)) -
     .       ((DSIN(ANGA/2)*DCOS(ANGB/2))*
     .        (DCOS(LONA)*DCOS(LONB)*DCOS(LATB-LATA)) + 
     .        (DSIN(LONA)*DSIN(LONB))))

C phew
        write (6,*) " D "
        write(6,*) D
        write (6,*) " F "
        write(6,*)F
                write (6,*) " G "
        write(6,*)G

c calculate transposes and inverses for Chang linear approximation
c        TRANSPOSE OF D
        CALL TRANSTHREETHREE(D,DTRANS)
c        TRANSPOSE OF G
        CALL TRANSTHREETHREE(G,GTRANS)
c        TRANSPOSE OF F
        CALL TRANSTHREETHREE(F,FTRANS)
c        INVERSE OF D
        CALL M33INV(D,DINV,OK_FLAG)
c        INVERSE OF DTRANS
        CALL M33INV(DTRANS,DTRANSINV,OK_FLAG)
        
        IF (OK_FLAG) THEN
          continue
        ELSE
         WRITE (6,*) ' Singular matrix, has no inverse.'
        END IF

C         then get the matrix given by
C        G.cov(A).G_trans + F.cov(B).F_trans

        CALL MATXMUL(G,3,3,3,3,A,3,3,3,3,GDOTA,3,3)
        CALL MATXMUL(GDOTA,3,3,3,3,GTRANS,3,3,3,3,CHANG1,3,3)

        CALL MATXMUL(F,3,3,3,3,B,3,3,3,3,FDOTB,3,3)
        CALL MATXMUL(FDOTB,3,3,3,3,FTRANS,3,3,3,3,CHANG2,3,3)
        
        CALL ADDMATS(CHANG1,CHANG2,DCDTRANS)
		
c		write(6,*)"DCDTRANS"
c	    write(6,*)DCDTRANS

C         this is approx. equal to DCDt
C
c        where C is the covariance matrix for rotation C
c
C        isolate C by calculating
C        D_inv.(D.cov(C).D_trans).D_trans_inv
 
        CALL MATXMUL(DINV,3,3,3,3,DCDTRANS,3,3,3,3,CDTRANS,3,3)
        CALL MATXMUL(CDTRANS,3,3,3,3,DTRANSINV,3,3,3,3,C,3,3)

c		write(6,*)"DTRANSINV"
c	    write(6,*)DTRANSINV

c		write(6,*)"DTRANS"
c	    write(6,*)DTRANS

		write(6,*)"DINV"
	    write(6,*)DINV

C adjust covariances with longitude for longitude's nonlinearity

        do 2110 i= 1,3 
          C(i,2) = C(i,2) * dcos(LATC)
          C(2,i) = C(2,i) * dcos(LATC)
2110    continue

C        write covariance matrix for C to file 
C	     (compile for all chrons outside fortran)
		OPEN (UNIT=13, FILE='covariances.dat', STATUS='UNKNOWN') 

C convert rotation params back to degrees for write
        LONC=LONC/RADDEG 
        LATC=LATC/RADDEG
        ANGC=ANGC/RADDEG
c        write(6,*) LONC,LATC
c	     write(6,*)C
        WRITE (13,*) LONC, LATC, ANGC, C
c(1,1), C(1,2), 
c     .       C(1,3), C(2,1), C(2,2), C(2,3), C(3,1), C(3,2), C(3,3)
	    CLOSE(13)
	    
	    CALL CONFI(C,LONC,LATC,ANGC)
	    
        STOP
        END



cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C subroutines
        
        

C and inverses:
C         https://caps.gsfc.nasa.gov/simpson/software/m33inv_f90.txt

C***********************************************************************************************************************************
C  M33INV  -  Compute the inverse of a 3x3 matrix.
C
C  A       = input 3x3 matrix to be inverted
C  AINV    = output 3x3 inverse of matrix A
C  OK_FLAG = (output) .TRUE. if the input matrix could be inverted, and .FALSE. if the input matrix is singular.
C***********************************************************************************************************************************

      SUBROUTINE M33INV (A, AINV, OK_FLAG)

      IMPLICIT NONE

      DOUBLE PRECISION A(3,3)
      DOUBLE PRECISION AINV(3,3)
      LOGICAL OK_FLAG

      DOUBLE PRECISION EPS 
      DOUBLE PRECISION DET
      DOUBLE PRECISION COFACTOR(3,3)
 
      EPS = 1.0D-10

      DET =   A(1,1)*A(2,2)*A(3,3)
     .            - A(1,1)*A(2,3)*A(3,2)
     .            - A(1,2)*A(2,1)*A(3,3)
     .            + A(1,2)*A(2,3)*A(3,1)
     .            + A(1,3)*A(2,1)*A(3,2)
     .            - A(1,3)*A(2,2)*A(3,1)

      IF (ABS(DET) .LE. EPS) THEN
         AINV = 0.0D0
         OK_FLAG = .FALSE.
         RETURN
      END IF

      COFACTOR(1,1) = +(A(2,2)*A(3,3)-A(2,3)*A(3,2))
      COFACTOR(1,2) = -(A(2,1)*A(3,3)-A(2,3)*A(3,1))
      COFACTOR(1,3) = +(A(2,1)*A(3,2)-A(2,2)*A(3,1))
      COFACTOR(2,1) = -(A(1,2)*A(3,3)-A(1,3)*A(3,2))
      COFACTOR(2,2) = +(A(1,1)*A(3,3)-A(1,3)*A(3,1))
      COFACTOR(2,3) = -(A(1,1)*A(3,2)-A(1,2)*A(3,1))
      COFACTOR(3,1) = +(A(1,2)*A(2,3)-A(1,3)*A(2,2))
      COFACTOR(3,2) = -(A(1,1)*A(2,3)-A(1,3)*A(2,1))
      COFACTOR(3,3) = +(A(1,1)*A(2,2)-A(1,2)*A(2,1))

      AINV = TRANSPOSE(COFACTOR) / DET

      OK_FLAG = .TRUE.

      RETURN

      END 


c
c
      subroutine addmats(A, B, C)
c
c     subroutine add3mats     1995     A Nankivell
c
c
c     the subroutine carries out the matrix addition
c
c                   C = A + B  
c 
c      where A, B, C are 3x3 matrices
c
c

      implicit none

      double precision A(3,3), B(3,3), C(3,3)
c
      integer i, j   

      do 10 i = 1, 3
        do 10 j = 1,3
          C(i,j) = A(i,j) + B(i,j)
10    continue

 
      return
      end


c
c
      subroutine MATXMUL( A, mamax, namax, ma, na, B, mbmax, nbmax,mb,
     .                 nb, C, mcmax, ncmax )
c      ---------------------------------------------------------------
c
c      subroutine mtxmul multiplies the ma * na matrix A
c      and the mb * nb matrix B to produce the ma * nb
c      matrix C defined by
c
c      C = A * B
c
c
      implicit none
c
      integer mamax, namax, ma, na
      integer mbmax, nbmax, mb, nb
      integer mcmax, ncmax

      double precision  A( mamax, namax ), B( mbmax, nbmax )
      double precision  c( mcmax, ncmax )
c
      integer i, j, k

      double precision sum

c
c----  check dimensions of matrices
c
      if( na .ne. mb ) then

        write( 6, 5 ) na, mb
5       format(/,5x,'error : matrix multiplication in subroutine',/,
     .           5x,'mtxmul cannot proceed because the number of',/,
     .           5x,'rows in matrix A ',i3,' and the number of',/,
     .           5x,'columns in matrix B ',i3,' are incompatible',/)

        stop

      end if
c
c----  check size of output matrix C
c
      if( ma .gt. mcmax .or. nb .gt. ncmax ) then

        write( 6, 10 )
10      format(/,5x,'error : error in subroutine mtxmul.',/,
     .           5x,'predicted dimensions of matrix C',/,
     .           5x,'exceed dimensions of array C',/)

        stop

      end if
c
c----  clean output array
c
      do 20 i = 1, mcmax
        do 20 j = 1, ncmax

          C( i,j ) = 0.0d0

20    continue

c
c----  perform matrix multiplication
c
      do 40 i = 1, ma
        do 40 j = 1, nb

        sum = 0.0d0

        do 30 k = 1, na
          sum = sum + A( i, k ) * B( k, j )
30      continue

        C( i, j ) = sum

40    continue

      return
      end

        SUBROUTINE TRANSTHREETHREE (MAT, TMAT)
        
        IMPLICIT NONE
        
        DOUBLE PRECISION MAT(3,3)
        DOUBLE PRECISION TMAT(3,3)

C        diagonal doesn't change
        
        TMAT(1,1)=MAT(1,1)
        TMAT(2,2)=MAT(2,2)
        TMAT(3,3)=MAT(3,3)
C        other six elements switch indices
        TMAT(2,1)=MAT(1,2)
        TMAT(3,1)=MAT(1,3)
        
        TMAT(1,2)=MAT(2,1)
        TMAT(3,2)=MAT(2,3)

        TMAT(1,3)=MAT(3,1)
        TMAT(2,3)=MAT(3,2)
                
        RETURN
        
        END 
        
        
        
        subroutine CONFI( C, LONC, LATC, ANGC )
     
C subroutine calculates ellipse dimensions from the
C combined rotation's covariances.        

C Fill array EVEC with COVMAT, as COVMAT as input to DSYEV would be
C overwritten on output with eigenvectors EVEC, but we need COVMAT
C again to calculate the eigenvectors for the 3-D case...
C 

        IMPLICIT NONE
        integer LWORK, IFAIL, i, j, INTEVAL2, INTEVAL1, INTEVAL3
        parameter (LWORK = 9)
	 	double precision WORK(LWORK), EVEC(3,3), C(3,3), EVAL(3)
        double precision RADDEG, LONC, LATC, ANGC, STDNORM
        REAL ax1, ax2, ax3, majang, minang
        
        RADDEG=0.1745329251994329D-01
        STDNORM=1.0D1

c        write(6,*) LONC
        do 2115 i = 1, 3
          do 2115 j = 1, 3
            EVEC(i,j) = C(i,j)*STDNORM
2115    continue
c        write(6,*) "covariances ",EVEC
        call DSYEV('V', 'L', 2, EVEC, 3, EVAL, WORK, LWORK, IFAIL)
        
c        write(6,*) "eigenvectors ",EVEC
c        write(6,*)"eigenvalues",EVAL

c ......... from these, determine the angle from horizontal of semi-major axis
c             and output details suitable for psvelomeca

		INTEVAL2=IDINT(EVAL(2))
		INTEVAL1=IDINT(EVAL(1))
		
c        ax1 = dsqrt(EVAL(1))
c        ax2 = dsqrt(EVAL(2))
        ax1 = dsqrt(EVAL(1)-INTEVAL1)
        ax2 = dsqrt(EVAL(2)-INTEVAL2)
        
c		write(6,*) EVAL(2), INTEVAL2, dsqrt(EVAL(2)-INTEVAL2)
c
c  * 2.45... calcell does this now
c
        minang = datan2( EVEC(1,1), EVEC(2,1) )/RADDEG
c        majang = datan2( EVEC(1,2), EVEC(2,2) )/RADDEG
        majang = datan2( EVEC(1,3), EVEC(2,3) )/RADDEG

        if (majang .lt. 0 ) majang = majang + 180.
        if (minang .lt. 0 ) minang = minang + 180.

		OPEN (UNIT=15, FILE='confint.dat', STATUS='UNKNOWN') 

        write ( 15, 2120 ) LONC, LATC, 0., 0.,
     .                     ax2, ax1, majang
        CLOSE(15)

2120    format ( 7(f15.6, 1x))

c.......... now find eigenvalues and eigenvectors of individual cov mat
c              -in gc degrees surface - 
C
C Fill array EVEC with 
C 
        do 2125 i = 1, 3
          do 2125 j = 1, i
            EVEC(i,j) = C(i,j)
2125    continue
c        write(6,*) EVEC

        call DSYEV('V', 'L', 3, EVEC, 3, EVAL, WORK, LWORK, IFAIL)

c ......... from these, determine the angle from horizontal of semi-major axis
c             and output details suitable for psvelomeca

		INTEVAL3=IDINT(EVAL(3))
		INTEVAL2=IDINT(EVAL(2))
		INTEVAL1=IDINT(EVAL(1))

c        ax1 = dsqrt(EVAL(1))
c        ax2 = dsqrt(EVAL(2))
c        ax3 = dsqrt(EVAL(3))
 
        ax1 = dsqrt(EVAL(1)-INTEVAL1)
        ax2 = dsqrt(EVAL(2)-INTEVAL2)
        ax3 = dsqrt(EVAL(3)-INTEVAL3)
c        write(6,*)"3 axes"
        write(6,*) "eigenvectors ",EVEC
        write(6,*)"eigenvalues",EVAL

c
c  * 2.79... now calcell does this...
c
        minang = datan2( EVEC(1,2), EVEC(2,2) )/RADDEG
        majang = datan2( EVEC(1,3), EVEC(2,3) )/RADDEG

        if (majang .lt. 0 ) majang = majang + 180.
        if (minang .lt. 0 ) minang = minang + 180.

		OPEN (UNIT=16, FILE='confints.dat', STATUS='UNKNOWN') 

        write ( 16, 2120 ) LONC, LATC, ANGC, 
     .                     ax3, ax2, ax1, majang
        CLOSE(16)

	    return
	    end

